<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SerialNoMode EnumType
 * @subpackage Enumerations
 */
class SerialNoMode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Constant for value 'AUTOMATIC'
     * @return string 'AUTOMATIC'
     */
    const VALUE_AUTOMATIC = 'AUTOMATIC';
    /**
     * Constant for value 'MANUAL'
     * @return string 'MANUAL'
     */
    const VALUE_MANUAL = 'MANUAL';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_AUTOMATIC
     * @uses self::VALUE_MANUAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_AUTOMATIC,
            self::VALUE_MANUAL,
        );
    }
}
