<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MessageLevel EnumType
 * @subpackage Enumerations
 */
class MessageLevel extends AbstractStructEnumBase
{
    /**
     * Constant for value 'INFO'
     * @return string 'INFO'
     */
    const VALUE_INFO = 'INFO';
    /**
     * Constant for value 'WARN'
     * @return string 'WARN'
     */
    const VALUE_WARN = 'WARN';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'FATAL'
     * @return string 'FATAL'
     */
    const VALUE_FATAL = 'FATAL';
    /**
     * Return allowed values
     * @uses self::VALUE_INFO
     * @uses self::VALUE_WARN
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_FATAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INFO,
            self::VALUE_WARN,
            self::VALUE_ERROR,
            self::VALUE_FATAL,
        );
    }
}
