<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for MessageErrorCode EnumType
 * @subpackage Enumerations
 */
class MessageErrorCode extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'VALIDATION_ERROR'
     * @return string 'VALIDATION_ERROR'
     */
    const VALUE_VALIDATION_ERROR = 'VALIDATION_ERROR';
    /**
     * Constant for value 'DATA_READ_ERROR'
     * @return string 'DATA_READ_ERROR'
     */
    const VALUE_DATA_READ_ERROR = 'DATA_READ_ERROR';
    /**
     * Constant for value 'DATA_READ_INVALID_CHARACTER'
     * @return string 'DATA_READ_INVALID_CHARACTER'
     */
    const VALUE_DATA_READ_INVALID_CHARACTER = 'DATA_READ_INVALID_CHARACTER';
    /**
     * Constant for value 'DATA_WRITE_ERROR'
     * @return string 'DATA_WRITE_ERROR'
     */
    const VALUE_DATA_WRITE_ERROR = 'DATA_WRITE_ERROR';
    /**
     * Constant for value 'DATA_WRITE_UQ_VIOLATION'
     * @return string 'DATA_WRITE_UQ_VIOLATION'
     */
    const VALUE_DATA_WRITE_UQ_VIOLATION = 'DATA_WRITE_UQ_VIOLATION';
    /**
     * Constant for value 'DATA_WRITE_TX_FAILURE'
     * @return string 'DATA_WRITE_TX_FAILURE'
     */
    const VALUE_DATA_WRITE_TX_FAILURE = 'DATA_WRITE_TX_FAILURE';
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_VALIDATION_ERROR
     * @uses self::VALUE_DATA_READ_ERROR
     * @uses self::VALUE_DATA_READ_INVALID_CHARACTER
     * @uses self::VALUE_DATA_WRITE_ERROR
     * @uses self::VALUE_DATA_WRITE_UQ_VIOLATION
     * @uses self::VALUE_DATA_WRITE_TX_FAILURE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_VALIDATION_ERROR,
            self::VALUE_DATA_READ_ERROR,
            self::VALUE_DATA_READ_INVALID_CHARACTER,
            self::VALUE_DATA_WRITE_ERROR,
            self::VALUE_DATA_WRITE_UQ_VIOLATION,
            self::VALUE_DATA_WRITE_TX_FAILURE,
        );
    }
}
