<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ComponentStatus EnumType
 * @subpackage Enumerations
 */
class ComponentStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'DOWN'
     * @return string 'DOWN'
     */
    const VALUE_DOWN = 'DOWN';
    /**
     * Constant for value 'STARTING_UP'
     * @return string 'STARTING_UP'
     */
    const VALUE_STARTING_UP = 'STARTING_UP';
    /**
     * Constant for value 'RUNNING'
     * @return string 'RUNNING'
     */
    const VALUE_RUNNING = 'RUNNING';
    /**
     * Constant for value 'SHUTTING_DOWN'
     * @return string 'SHUTTING_DOWN'
     */
    const VALUE_SHUTTING_DOWN = 'SHUTTING_DOWN';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'NONE'
     * @return string 'NONE'
     */
    const VALUE_NONE = 'NONE';
    /**
     * Return allowed values
     * @uses self::VALUE_DOWN
     * @uses self::VALUE_STARTING_UP
     * @uses self::VALUE_RUNNING
     * @uses self::VALUE_SHUTTING_DOWN
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DOWN,
            self::VALUE_STARTING_UP,
            self::VALUE_RUNNING,
            self::VALUE_SHUTTING_DOWN,
            self::VALUE_ERROR,
            self::VALUE_NONE,
        );
    }
}
