<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CardType EnumType
 * @subpackage Enumerations
 */
class CardType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'OTHER'
     * @return string 'OTHER'
     */
    const VALUE_OTHER = 'OTHER';
    /**
     * Constant for value 'INHOUSE'
     * @return string 'INHOUSE'
     */
    const VALUE_INHOUSE = 'INHOUSE';
    /**
     * Constant for value 'LOYALTY'
     * @return string 'LOYALTY'
     */
    const VALUE_LOYALTY = 'LOYALTY';
    /**
     * Return allowed values
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_INHOUSE
     * @uses self::VALUE_LOYALTY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHER,
            self::VALUE_INHOUSE,
            self::VALUE_LOYALTY,
        );
    }
}
