<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AdvertisingPermission EnumType
 * @subpackage Enumerations
 */
class AdvertisingPermission extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'OptInRequested'
     * @return string 'OptInRequested'
     */
    const VALUE_OPT_IN_REQUESTED = 'OptInRequested';
    /**
     * Constant for value 'OptInGranted'
     * @return string 'OptInGranted'
     */
    const VALUE_OPT_IN_GRANTED = 'OptInGranted';
    /**
     * Constant for value 'Granted'
     * @return string 'Granted'
     */
    const VALUE_GRANTED = 'Granted';
    /**
     * Constant for value 'Denied'
     * @return string 'Denied'
     */
    const VALUE_DENIED = 'Denied';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_OPT_IN_REQUESTED
     * @uses self::VALUE_OPT_IN_GRANTED
     * @uses self::VALUE_GRANTED
     * @uses self::VALUE_DENIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_OPT_IN_REQUESTED,
            self::VALUE_OPT_IN_GRANTED,
            self::VALUE_GRANTED,
            self::VALUE_DENIED,
        );
    }
}
