<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSalesReceipt ArrayType
 * @subpackage Arrays
 */
class ArrayOfSalesReceipt extends AbstractStructArrayBase
{
    /**
     * The SalesReceipt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SalesReceipt[]
     */
    public $SalesReceipt;
    /**
     * Constructor method for ArrayOfSalesReceipt
     * @uses ArrayOfSalesReceipt::setSalesReceipt()
     * @param \StructType\SalesReceipt[] $salesReceipt
     */
    public function __construct(array $salesReceipt = array())
    {
        $this
            ->setSalesReceipt($salesReceipt);
    }
    /**
     * Get SalesReceipt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SalesReceipt[]|null
     */
    public function getSalesReceipt()
    {
        return isset($this->SalesReceipt) ? $this->SalesReceipt : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesReceipt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesReceipt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesReceiptForArrayConstraintsFromSetSalesReceipt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSalesReceiptSalesReceiptItem) {
            // validation for constraint: itemType
            if (!$arrayOfSalesReceiptSalesReceiptItem instanceof \StructType\SalesReceipt) {
                $invalidValues[] = is_object($arrayOfSalesReceiptSalesReceiptItem) ? get_class($arrayOfSalesReceiptSalesReceiptItem) : sprintf('%s(%s)', gettype($arrayOfSalesReceiptSalesReceiptItem), var_export($arrayOfSalesReceiptSalesReceiptItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesReceipt property can only contain items of type \StructType\SalesReceipt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesReceipt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SalesReceipt[] $salesReceipt
     * @return \ArrayType\ArrayOfSalesReceipt
     */
    public function setSalesReceipt(array $salesReceipt = array())
    {
        // validation for constraint: array
        if ('' !== ($salesReceiptArrayErrorMessage = self::validateSalesReceiptForArrayConstraintsFromSetSalesReceipt($salesReceipt))) {
            throw new \InvalidArgumentException($salesReceiptArrayErrorMessage, __LINE__);
        }
        if (is_null($salesReceipt) || (is_array($salesReceipt) && empty($salesReceipt))) {
            unset($this->SalesReceipt);
        } else {
            $this->SalesReceipt = $salesReceipt;
        }
        return $this;
    }
    /**
     * Add item to SalesReceipt value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesReceipt $item
     * @return \ArrayType\ArrayOfSalesReceipt
     */
    public function addToSalesReceipt(\StructType\SalesReceipt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesReceipt) {
            throw new \InvalidArgumentException(sprintf('The SalesReceipt property can only contain items of type \StructType\SalesReceipt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesReceipt[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SalesReceipt|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SalesReceipt|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SalesReceipt|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SalesReceipt|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SalesReceipt|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SalesReceipt
     */
    public function getAttributeName()
    {
        return 'SalesReceipt';
    }
}
