<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentType ArrayType
 * @subpackage Arrays
 */
class ArrayOfPaymentType extends AbstractStructArrayBase
{
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentType[]
     */
    public $PaymentType;
    /**
     * Constructor method for ArrayOfPaymentType
     * @uses ArrayOfPaymentType::setPaymentType()
     * @param \StructType\PaymentType[] $paymentType
     */
    public function __construct(array $paymentType = array())
    {
        $this
            ->setPaymentType($paymentType);
    }
    /**
     * Get PaymentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentType[]|null
     */
    public function getPaymentType()
    {
        return isset($this->PaymentType) ? $this->PaymentType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentTypeForArrayConstraintsFromSetPaymentType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPaymentTypePaymentTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentTypePaymentTypeItem instanceof \StructType\PaymentType) {
                $invalidValues[] = is_object($arrayOfPaymentTypePaymentTypeItem) ? get_class($arrayOfPaymentTypePaymentTypeItem) : sprintf('%s(%s)', gettype($arrayOfPaymentTypePaymentTypeItem), var_export($arrayOfPaymentTypePaymentTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentType property can only contain items of type \StructType\PaymentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentType[] $paymentType
     * @return \ArrayType\ArrayOfPaymentType
     */
    public function setPaymentType(array $paymentType = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentTypeArrayErrorMessage = self::validatePaymentTypeForArrayConstraintsFromSetPaymentType($paymentType))) {
            throw new \InvalidArgumentException($paymentTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($paymentType) || (is_array($paymentType) && empty($paymentType))) {
            unset($this->PaymentType);
        } else {
            $this->PaymentType = $paymentType;
        }
        return $this;
    }
    /**
     * Add item to PaymentType value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentType $item
     * @return \ArrayType\ArrayOfPaymentType
     */
    public function addToPaymentType(\StructType\PaymentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentType) {
            throw new \InvalidArgumentException(sprintf('The PaymentType property can only contain items of type \StructType\PaymentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PaymentType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PaymentType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PaymentType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PaymentType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PaymentType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentType
     */
    public function getAttributeName()
    {
        return 'PaymentType';
    }
}
