<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderStockPosition ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderStockPosition extends AbstractStructArrayBase
{
    /**
     * The OrderStockPosition
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderStockPosition[]
     */
    public $OrderStockPosition;
    /**
     * Constructor method for ArrayOfOrderStockPosition
     * @uses ArrayOfOrderStockPosition::setOrderStockPosition()
     * @param \StructType\OrderStockPosition[] $orderStockPosition
     */
    public function __construct(array $orderStockPosition = array())
    {
        $this
            ->setOrderStockPosition($orderStockPosition);
    }
    /**
     * Get OrderStockPosition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderStockPosition[]|null
     */
    public function getOrderStockPosition()
    {
        return isset($this->OrderStockPosition) ? $this->OrderStockPosition : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderStockPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderStockPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderStockPositionForArrayConstraintsFromSetOrderStockPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderStockPositionOrderStockPositionItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderStockPositionOrderStockPositionItem instanceof \StructType\OrderStockPosition) {
                $invalidValues[] = is_object($arrayOfOrderStockPositionOrderStockPositionItem) ? get_class($arrayOfOrderStockPositionOrderStockPositionItem) : sprintf('%s(%s)', gettype($arrayOfOrderStockPositionOrderStockPositionItem), var_export($arrayOfOrderStockPositionOrderStockPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderStockPosition property can only contain items of type \StructType\OrderStockPosition, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderStockPosition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStockPosition[] $orderStockPosition
     * @return \ArrayType\ArrayOfOrderStockPosition
     */
    public function setOrderStockPosition(array $orderStockPosition = array())
    {
        // validation for constraint: array
        if ('' !== ($orderStockPositionArrayErrorMessage = self::validateOrderStockPositionForArrayConstraintsFromSetOrderStockPosition($orderStockPosition))) {
            throw new \InvalidArgumentException($orderStockPositionArrayErrorMessage, __LINE__);
        }
        if (is_null($orderStockPosition) || (is_array($orderStockPosition) && empty($orderStockPosition))) {
            unset($this->OrderStockPosition);
        } else {
            $this->OrderStockPosition = $orderStockPosition;
        }
        return $this;
    }
    /**
     * Add item to OrderStockPosition value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStockPosition $item
     * @return \ArrayType\ArrayOfOrderStockPosition
     */
    public function addToOrderStockPosition(\StructType\OrderStockPosition $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderStockPosition) {
            throw new \InvalidArgumentException(sprintf('The OrderStockPosition property can only contain items of type \StructType\OrderStockPosition, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderStockPosition[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderStockPosition|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderStockPosition|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderStockPosition|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderStockPosition|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderStockPosition|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderStockPosition
     */
    public function getAttributeName()
    {
        return 'OrderStockPosition';
    }
}
