<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderStock ArrayType
 * @subpackage Arrays
 */
class ArrayOfOrderStock extends AbstractStructArrayBase
{
    /**
     * The OrderStock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderStock[]
     */
    public $OrderStock;
    /**
     * Constructor method for ArrayOfOrderStock
     * @uses ArrayOfOrderStock::setOrderStock()
     * @param \StructType\OrderStock[] $orderStock
     */
    public function __construct(array $orderStock = array())
    {
        $this
            ->setOrderStock($orderStock);
    }
    /**
     * Get OrderStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderStock[]|null
     */
    public function getOrderStock()
    {
        return isset($this->OrderStock) ? $this->OrderStock : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderStock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderStock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderStockForArrayConstraintsFromSetOrderStock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderStockOrderStockItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderStockOrderStockItem instanceof \StructType\OrderStock) {
                $invalidValues[] = is_object($arrayOfOrderStockOrderStockItem) ? get_class($arrayOfOrderStockOrderStockItem) : sprintf('%s(%s)', gettype($arrayOfOrderStockOrderStockItem), var_export($arrayOfOrderStockOrderStockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderStock property can only contain items of type \StructType\OrderStock, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStock[] $orderStock
     * @return \ArrayType\ArrayOfOrderStock
     */
    public function setOrderStock(array $orderStock = array())
    {
        // validation for constraint: array
        if ('' !== ($orderStockArrayErrorMessage = self::validateOrderStockForArrayConstraintsFromSetOrderStock($orderStock))) {
            throw new \InvalidArgumentException($orderStockArrayErrorMessage, __LINE__);
        }
        if (is_null($orderStock) || (is_array($orderStock) && empty($orderStock))) {
            unset($this->OrderStock);
        } else {
            $this->OrderStock = $orderStock;
        }
        return $this;
    }
    /**
     * Add item to OrderStock value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderStock $item
     * @return \ArrayType\ArrayOfOrderStock
     */
    public function addToOrderStock(\StructType\OrderStock $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderStock) {
            throw new \InvalidArgumentException(sprintf('The OrderStock property can only contain items of type \StructType\OrderStock, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderStock[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderStock|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderStock|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderStock|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderStock|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderStock|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderStock
     */
    public function getAttributeName()
    {
        return 'OrderStock';
    }
}
