<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfManufacturer ArrayType
 * @subpackage Arrays
 */
class ArrayOfManufacturer extends AbstractStructArrayBase
{
    /**
     * The Manufacturer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Manufacturer[]
     */
    public $Manufacturer;
    /**
     * Constructor method for ArrayOfManufacturer
     * @uses ArrayOfManufacturer::setManufacturer()
     * @param \StructType\Manufacturer[] $manufacturer
     */
    public function __construct(array $manufacturer = array())
    {
        $this
            ->setManufacturer($manufacturer);
    }
    /**
     * Get Manufacturer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Manufacturer[]|null
     */
    public function getManufacturer()
    {
        return isset($this->Manufacturer) ? $this->Manufacturer : null;
    }
    /**
     * This method is responsible for validating the values passed to the setManufacturer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManufacturer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManufacturerForArrayConstraintsFromSetManufacturer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfManufacturerManufacturerItem) {
            // validation for constraint: itemType
            if (!$arrayOfManufacturerManufacturerItem instanceof \StructType\Manufacturer) {
                $invalidValues[] = is_object($arrayOfManufacturerManufacturerItem) ? get_class($arrayOfManufacturerManufacturerItem) : sprintf('%s(%s)', gettype($arrayOfManufacturerManufacturerItem), var_export($arrayOfManufacturerManufacturerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Manufacturer property can only contain items of type \StructType\Manufacturer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Manufacturer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Manufacturer[] $manufacturer
     * @return \ArrayType\ArrayOfManufacturer
     */
    public function setManufacturer(array $manufacturer = array())
    {
        // validation for constraint: array
        if ('' !== ($manufacturerArrayErrorMessage = self::validateManufacturerForArrayConstraintsFromSetManufacturer($manufacturer))) {
            throw new \InvalidArgumentException($manufacturerArrayErrorMessage, __LINE__);
        }
        if (is_null($manufacturer) || (is_array($manufacturer) && empty($manufacturer))) {
            unset($this->Manufacturer);
        } else {
            $this->Manufacturer = $manufacturer;
        }
        return $this;
    }
    /**
     * Add item to Manufacturer value
     * @throws \InvalidArgumentException
     * @param \StructType\Manufacturer $item
     * @return \ArrayType\ArrayOfManufacturer
     */
    public function addToManufacturer(\StructType\Manufacturer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Manufacturer) {
            throw new \InvalidArgumentException(sprintf('The Manufacturer property can only contain items of type \StructType\Manufacturer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Manufacturer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Manufacturer|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Manufacturer|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Manufacturer|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Manufacturer|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Manufacturer|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Manufacturer
     */
    public function getAttributeName()
    {
        return 'Manufacturer';
    }
}
