<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCommChannel ArrayType
 * @subpackage Arrays
 */
class ArrayOfCommChannel extends AbstractStructArrayBase
{
    /**
     * The CommChannel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CommChannel[]
     */
    public $CommChannel;
    /**
     * Constructor method for ArrayOfCommChannel
     * @uses ArrayOfCommChannel::setCommChannel()
     * @param \StructType\CommChannel[] $commChannel
     */
    public function __construct(array $commChannel = array())
    {
        $this
            ->setCommChannel($commChannel);
    }
    /**
     * Get CommChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CommChannel[]|null
     */
    public function getCommChannel()
    {
        return isset($this->CommChannel) ? $this->CommChannel : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCommChannel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommChannel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommChannelForArrayConstraintsFromSetCommChannel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCommChannelCommChannelItem) {
            // validation for constraint: itemType
            if (!$arrayOfCommChannelCommChannelItem instanceof \StructType\CommChannel) {
                $invalidValues[] = is_object($arrayOfCommChannelCommChannelItem) ? get_class($arrayOfCommChannelCommChannelItem) : sprintf('%s(%s)', gettype($arrayOfCommChannelCommChannelItem), var_export($arrayOfCommChannelCommChannelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommChannel property can only contain items of type \StructType\CommChannel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CommChannel[] $commChannel
     * @return \ArrayType\ArrayOfCommChannel
     */
    public function setCommChannel(array $commChannel = array())
    {
        // validation for constraint: array
        if ('' !== ($commChannelArrayErrorMessage = self::validateCommChannelForArrayConstraintsFromSetCommChannel($commChannel))) {
            throw new \InvalidArgumentException($commChannelArrayErrorMessage, __LINE__);
        }
        if (is_null($commChannel) || (is_array($commChannel) && empty($commChannel))) {
            unset($this->CommChannel);
        } else {
            $this->CommChannel = $commChannel;
        }
        return $this;
    }
    /**
     * Add item to CommChannel value
     * @throws \InvalidArgumentException
     * @param \StructType\CommChannel $item
     * @return \ArrayType\ArrayOfCommChannel
     */
    public function addToCommChannel(\StructType\CommChannel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommChannel) {
            throw new \InvalidArgumentException(sprintf('The CommChannel property can only contain items of type \StructType\CommChannel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommChannel[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CommChannel|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CommChannel|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CommChannel|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CommChannel|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CommChannel|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CommChannel
     */
    public function getAttributeName()
    {
        return 'CommChannel';
    }
}
