<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVouchersPdf GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetVouchersPdf extends AbstractStructBase
{
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $format;
    /**
     * The extraInfoFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $extraInfoFormat;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The voucherNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiArray\GenikiArrayOfString
     */
    public $voucherNumbers;
    /**
     * Constructor method for GetVouchersPdf
     * @uses GenikiGetVouchersPdf::setFormat()
     * @uses GenikiGetVouchersPdf::setExtraInfoFormat()
     * @uses GenikiGetVouchersPdf::setAuthKey()
     * @uses GenikiGetVouchersPdf::setVoucherNumbers()
     * @param string $format
     * @param string $extraInfoFormat
     * @param string $authKey
     * @param \Geniki\GenikiArray\GenikiArrayOfString $voucherNumbers
     */
    public function __construct($format = null, $extraInfoFormat = null, $authKey = null, \Geniki\GenikiArray\GenikiArrayOfString $voucherNumbers = null)
    {
        $this
            ->setFormat($format)
            ->setExtraInfoFormat($extraInfoFormat)
            ->setAuthKey($authKey)
            ->setVoucherNumbers($voucherNumbers);
    }
    /**
     * Get format value
     * @return string
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Geniki\GenikiEnum\GenikiMediaFormat::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiMediaFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Geniki\GenikiStruct\GenikiGetVouchersPdf
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiMediaFormat::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiMediaFormat', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \Geniki\GenikiEnum\GenikiMediaFormat::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get extraInfoFormat value
     * @return string
     */
    public function getExtraInfoFormat()
    {
        return $this->extraInfoFormat;
    }
    /**
     * Set extraInfoFormat value
     * @uses \Geniki\GenikiEnum\GenikiExtraInfoFormat::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiExtraInfoFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $extraInfoFormat
     * @return \Geniki\GenikiStruct\GenikiGetVouchersPdf
     */
    public function setExtraInfoFormat($extraInfoFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiExtraInfoFormat::valueIsValid($extraInfoFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiExtraInfoFormat', is_array($extraInfoFormat) ? implode(', ', $extraInfoFormat) : var_export($extraInfoFormat, true), implode(', ', \Geniki\GenikiEnum\GenikiExtraInfoFormat::getValidValues())), __LINE__);
        }
        $this->extraInfoFormat = $extraInfoFormat;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiGetVouchersPdf
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get voucherNumbers value
     * @return \Geniki\GenikiArray\GenikiArrayOfString|null
     */
    public function getVoucherNumbers()
    {
        return $this->voucherNumbers;
    }
    /**
     * Set voucherNumbers value
     * @param \Geniki\GenikiArray\GenikiArrayOfString $voucherNumbers
     * @return \Geniki\GenikiStruct\GenikiGetVouchersPdf
     */
    public function setVoucherNumbers(\Geniki\GenikiArray\GenikiArrayOfString $voucherNumbers = null)
    {
        $this->voucherNumbers = $voucherNumbers;
        return $this;
    }
}
