<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddExtraInfo GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiAddExtraInfo extends AbstractStructBase
{
    /**
     * The jobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $jobId;
    /**
     * The extraInfoFormat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $extraInfoFormat;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The extraInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $extraInfo;
    /**
     * Constructor method for AddExtraInfo
     * @uses GenikiAddExtraInfo::setJobId()
     * @uses GenikiAddExtraInfo::setExtraInfoFormat()
     * @uses GenikiAddExtraInfo::setAuthKey()
     * @uses GenikiAddExtraInfo::setExtraInfo()
     * @param int $jobId
     * @param string $extraInfoFormat
     * @param string $authKey
     * @param string $extraInfo
     */
    public function __construct($jobId = null, $extraInfoFormat = null, $authKey = null, $extraInfo = null)
    {
        $this
            ->setJobId($jobId)
            ->setExtraInfoFormat($extraInfoFormat)
            ->setAuthKey($authKey)
            ->setExtraInfo($extraInfo);
    }
    /**
     * Get jobId value
     * @return int
     */
    public function getJobId()
    {
        return $this->jobId;
    }
    /**
     * Set jobId value
     * @param int $jobId
     * @return \Geniki\GenikiStruct\GenikiAddExtraInfo
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->jobId = $jobId;
        return $this;
    }
    /**
     * Get extraInfoFormat value
     * @return string
     */
    public function getExtraInfoFormat()
    {
        return $this->extraInfoFormat;
    }
    /**
     * Set extraInfoFormat value
     * @uses \Geniki\GenikiEnum\GenikiExtraInfoFormat::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiExtraInfoFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $extraInfoFormat
     * @return \Geniki\GenikiStruct\GenikiAddExtraInfo
     */
    public function setExtraInfoFormat($extraInfoFormat = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiExtraInfoFormat::valueIsValid($extraInfoFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiExtraInfoFormat', is_array($extraInfoFormat) ? implode(', ', $extraInfoFormat) : var_export($extraInfoFormat, true), implode(', ', \Geniki\GenikiEnum\GenikiExtraInfoFormat::getValidValues())), __LINE__);
        }
        $this->extraInfoFormat = $extraInfoFormat;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiAddExtraInfo
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get extraInfo value
     * @return string|null
     */
    public function getExtraInfo()
    {
        return $this->extraInfo;
    }
    /**
     * Set extraInfo value
     * @param string $extraInfo
     * @return \Geniki\GenikiStruct\GenikiAddExtraInfo
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        $this->extraInfo = $extraInfo;
        return $this;
    }
}
