<?php

namespace Geniki\GenikiEnum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for JobType GenikiEnum
 * @package Geniki
 * @subpackage Enumerations
 */
class GenikiJobType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Voucher'
     * @return string 'Voucher'
     */
    const VALUE_VOUCHER = 'Voucher';
    /**
     * Constant for value 'Pickup'
     * @return string 'Pickup'
     */
    const VALUE_PICKUP = 'Pickup';
    /**
     * Constant for value 'SendAndReturn'
     * @return string 'SendAndReturn'
     */
    const VALUE_SEND_AND_RETURN = 'SendAndReturn';
    /**
     * Return allowed values
     * @uses self::VALUE_VOUCHER
     * @uses self::VALUE_PICKUP
     * @uses self::VALUE_SEND_AND_RETURN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VOUCHER,
            self::VALUE_PICKUP,
            self::VALUE_SEND_AND_RETURN,
        );
    }
}
