<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPickupJobStatusResult GenikiStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPickupJobStatusResult
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetPickupJobStatusResult extends GenikiMethodResult
{
    /**
     * The JobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $JobId;
    /**
     * The StatusDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusDate;
    /**
     * The Vouchers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiArray\GenikiArrayOfString
     */
    public $Vouchers;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for GetPickupJobStatusResult
     * @uses GenikiGetPickupJobStatusResult::setJobId()
     * @uses GenikiGetPickupJobStatusResult::setStatusDate()
     * @uses GenikiGetPickupJobStatusResult::setVouchers()
     * @uses GenikiGetPickupJobStatusResult::setStatus()
     * @param int $jobId
     * @param string $statusDate
     * @param \Geniki\GenikiArray\GenikiArrayOfString $vouchers
     * @param string $status
     */
    public function __construct($jobId = null, $statusDate = null, \Geniki\GenikiArray\GenikiArrayOfString $vouchers = null, $status = null)
    {
        $this
            ->setJobId($jobId)
            ->setStatusDate($statusDate)
            ->setVouchers($vouchers)
            ->setStatus($status);
    }
    /**
     * Get JobId value
     * @return int
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param int $jobId
     * @return \Geniki\GenikiStruct\GenikiGetPickupJobStatusResult
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \Geniki\GenikiStruct\GenikiGetPickupJobStatusResult
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get Vouchers value
     * @return \Geniki\GenikiArray\GenikiArrayOfString|null
     */
    public function getVouchers()
    {
        return $this->Vouchers;
    }
    /**
     * Set Vouchers value
     * @param \Geniki\GenikiArray\GenikiArrayOfString $vouchers
     * @return \Geniki\GenikiStruct\GenikiGetPickupJobStatusResult
     */
    public function setVouchers(\Geniki\GenikiArray\GenikiArrayOfString $vouchers = null)
    {
        $this->Vouchers = $vouchers;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Geniki\GenikiStruct\GenikiGetPickupJobStatusResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
