<?php

namespace Geniki\GenikiEnum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for VoucherState GenikiEnum
 * @package Geniki
 * @subpackage Enumerations
 */
class GenikiVoucherState extends AbstractStructEnumBase
{
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Constant for value 'Open'
     * @return string 'Open'
     */
    const VALUE_OPEN = 'Open';
    /**
     * Constant for value 'Closed'
     * @return string 'Closed'
     */
    const VALUE_CLOSED = 'Closed';
    /**
     * Constant for value 'ClosedActive'
     * @return string 'ClosedActive'
     */
    const VALUE_CLOSED_ACTIVE = 'ClosedActive';
    /**
     * Constant for value 'ClosedCanceled'
     * @return string 'ClosedCanceled'
     */
    const VALUE_CLOSED_CANCELED = 'ClosedCanceled';
    /**
     * Return allowed values
     * @uses self::VALUE_ALL
     * @uses self::VALUE_OPEN
     * @uses self::VALUE_CLOSED
     * @uses self::VALUE_CLOSED_ACTIVE
     * @uses self::VALUE_CLOSED_CANCELED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALL,
            self::VALUE_OPEN,
            self::VALUE_CLOSED,
            self::VALUE_CLOSED_ACTIVE,
            self::VALUE_CLOSED_CANCELED,
        );
    }
}
