<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelJob GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCancelJob extends AbstractStructBase
{
    /**
     * The nJobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nJobId;
    /**
     * The bCancel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $bCancel;
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * Constructor method for CancelJob
     * @uses GenikiCancelJob::setNJobId()
     * @uses GenikiCancelJob::setBCancel()
     * @uses GenikiCancelJob::setSAuthKey()
     * @param int $nJobId
     * @param bool $bCancel
     * @param string $sAuthKey
     */
    public function __construct($nJobId = null, $bCancel = null, $sAuthKey = null)
    {
        $this
            ->setNJobId($nJobId)
            ->setBCancel($bCancel)
            ->setSAuthKey($sAuthKey);
    }
    /**
     * Get nJobId value
     * @return int
     */
    public function getNJobId()
    {
        return $this->nJobId;
    }
    /**
     * Set nJobId value
     * @param int $nJobId
     * @return \Geniki\GenikiStruct\GenikiCancelJob
     */
    public function setNJobId($nJobId = null)
    {
        // validation for constraint: int
        if (!is_null($nJobId) && !(is_int($nJobId) || ctype_digit($nJobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nJobId, true), gettype($nJobId)), __LINE__);
        }
        $this->nJobId = $nJobId;
        return $this;
    }
    /**
     * Get bCancel value
     * @return bool
     */
    public function getBCancel()
    {
        return $this->bCancel;
    }
    /**
     * Set bCancel value
     * @param bool $bCancel
     * @return \Geniki\GenikiStruct\GenikiCancelJob
     */
    public function setBCancel($bCancel = null)
    {
        // validation for constraint: boolean
        if (!is_null($bCancel) && !is_bool($bCancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bCancel, true), gettype($bCancel)), __LINE__);
        }
        $this->bCancel = $bCancel;
        return $this;
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiCancelJob
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
}
