<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Record GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiRecord extends AbstractStructBase
{
    /**
     * The Pieces
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Pieces;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Weight;
    /**
     * The CodAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodAmount;
    /**
     * The InsAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InsAmount;
    /**
     * The ReceivedDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ReceivedDate;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Country;
    /**
     * The CountryIso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryIso;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Zip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The Destination
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination;
    /**
     * The Courier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Courier;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Services;
    /**
     * The VoucherNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherNo;
    /**
     * The SubCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubCode;
    /**
     * The BelongsTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BelongsTo;
    /**
     * The DeliverTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliverTo;
    /**
     * The ContentsDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentsDescription;
    /**
     * The SendAndReturnRecipient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendAndReturnRecipient;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtraInfo;
    /**
     * Constructor method for Record
     * @uses GenikiRecord::setPieces()
     * @uses GenikiRecord::setWeight()
     * @uses GenikiRecord::setCodAmount()
     * @uses GenikiRecord::setInsAmount()
     * @uses GenikiRecord::setReceivedDate()
     * @uses GenikiRecord::setOrderId()
     * @uses GenikiRecord::setName()
     * @uses GenikiRecord::setAddress()
     * @uses GenikiRecord::setEmail()
     * @uses GenikiRecord::setCountry()
     * @uses GenikiRecord::setCountryIso()
     * @uses GenikiRecord::setCity()
     * @uses GenikiRecord::setTelephone()
     * @uses GenikiRecord::setZip()
     * @uses GenikiRecord::setDestination()
     * @uses GenikiRecord::setCourier()
     * @uses GenikiRecord::setComments()
     * @uses GenikiRecord::setServices()
     * @uses GenikiRecord::setVoucherNo()
     * @uses GenikiRecord::setSubCode()
     * @uses GenikiRecord::setBelongsTo()
     * @uses GenikiRecord::setDeliverTo()
     * @uses GenikiRecord::setContentsDescription()
     * @uses GenikiRecord::setSendAndReturnRecipient()
     * @uses GenikiRecord::setExtraInfo()
     * @param int $pieces
     * @param float $weight
     * @param float $codAmount
     * @param float $insAmount
     * @param string $receivedDate
     * @param string $orderId
     * @param string $name
     * @param string $address
     * @param string $email
     * @param string $country
     * @param string $countryIso
     * @param string $city
     * @param string $telephone
     * @param string $zip
     * @param string $destination
     * @param string $courier
     * @param string $comments
     * @param string $services
     * @param string $voucherNo
     * @param string $subCode
     * @param string $belongsTo
     * @param string $deliverTo
     * @param string $contentsDescription
     * @param string $sendAndReturnRecipient
     * @param string $extraInfo
     */
    public function __construct($pieces = null, $weight = null, $codAmount = null, $insAmount = null, $receivedDate = null, $orderId = null, $name = null, $address = null, $email = null, $country = null, $countryIso = null, $city = null, $telephone = null, $zip = null, $destination = null, $courier = null, $comments = null, $services = null, $voucherNo = null, $subCode = null, $belongsTo = null, $deliverTo = null, $contentsDescription = null, $sendAndReturnRecipient = null, $extraInfo = null)
    {
        $this
            ->setPieces($pieces)
            ->setWeight($weight)
            ->setCodAmount($codAmount)
            ->setInsAmount($insAmount)
            ->setReceivedDate($receivedDate)
            ->setOrderId($orderId)
            ->setName($name)
            ->setAddress($address)
            ->setEmail($email)
            ->setCountry($country)
            ->setCountryIso($countryIso)
            ->setCity($city)
            ->setTelephone($telephone)
            ->setZip($zip)
            ->setDestination($destination)
            ->setCourier($courier)
            ->setComments($comments)
            ->setServices($services)
            ->setVoucherNo($voucherNo)
            ->setSubCode($subCode)
            ->setBelongsTo($belongsTo)
            ->setDeliverTo($deliverTo)
            ->setContentsDescription($contentsDescription)
            ->setSendAndReturnRecipient($sendAndReturnRecipient)
            ->setExtraInfo($extraInfo);
    }
    /**
     * Get Pieces value
     * @return int
     */
    public function getPieces()
    {
        return $this->Pieces;
    }
    /**
     * Set Pieces value
     * @param int $pieces
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setPieces($pieces = null)
    {
        // validation for constraint: int
        if (!is_null($pieces) && !(is_int($pieces) || ctype_digit($pieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pieces, true), gettype($pieces)), __LINE__);
        }
        $this->Pieces = $pieces;
        return $this;
    }
    /**
     * Get Weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param float $weight
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get CodAmount value
     * @return float
     */
    public function getCodAmount()
    {
        return $this->CodAmount;
    }
    /**
     * Set CodAmount value
     * @param float $codAmount
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setCodAmount($codAmount = null)
    {
        // validation for constraint: float
        if (!is_null($codAmount) && !(is_float($codAmount) || is_numeric($codAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codAmount, true), gettype($codAmount)), __LINE__);
        }
        $this->CodAmount = $codAmount;
        return $this;
    }
    /**
     * Get InsAmount value
     * @return float
     */
    public function getInsAmount()
    {
        return $this->InsAmount;
    }
    /**
     * Set InsAmount value
     * @param float $insAmount
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setInsAmount($insAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insAmount) && !(is_float($insAmount) || is_numeric($insAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insAmount, true), gettype($insAmount)), __LINE__);
        }
        $this->InsAmount = $insAmount;
        return $this;
    }
    /**
     * Get ReceivedDate value
     * @return string
     */
    public function getReceivedDate()
    {
        return $this->ReceivedDate;
    }
    /**
     * Set ReceivedDate value
     * @param string $receivedDate
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setReceivedDate($receivedDate = null)
    {
        // validation for constraint: string
        if (!is_null($receivedDate) && !is_string($receivedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivedDate, true), gettype($receivedDate)), __LINE__);
        }
        $this->ReceivedDate = $receivedDate;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address, true), gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get CountryIso value
     * @return string|null
     */
    public function getCountryIso()
    {
        return $this->CountryIso;
    }
    /**
     * Set CountryIso value
     * @param string $countryIso
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setCountryIso($countryIso = null)
    {
        // validation for constraint: string
        if (!is_null($countryIso) && !is_string($countryIso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryIso, true), gettype($countryIso)), __LINE__);
        }
        $this->CountryIso = $countryIso;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->Destination;
    }
    /**
     * Set Destination value
     * @param string $destination
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination, true), gettype($destination)), __LINE__);
        }
        $this->Destination = $destination;
        return $this;
    }
    /**
     * Get Courier value
     * @return string|null
     */
    public function getCourier()
    {
        return $this->Courier;
    }
    /**
     * Set Courier value
     * @param string $courier
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setCourier($courier = null)
    {
        // validation for constraint: string
        if (!is_null($courier) && !is_string($courier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($courier, true), gettype($courier)), __LINE__);
        }
        $this->Courier = $courier;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get Services value
     * @return string|null
     */
    public function getServices()
    {
        return $this->Services;
    }
    /**
     * Set Services value
     * @param string $services
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setServices($services = null)
    {
        // validation for constraint: string
        if (!is_null($services) && !is_string($services)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($services, true), gettype($services)), __LINE__);
        }
        $this->Services = $services;
        return $this;
    }
    /**
     * Get VoucherNo value
     * @return string|null
     */
    public function getVoucherNo()
    {
        return $this->VoucherNo;
    }
    /**
     * Set VoucherNo value
     * @param string $voucherNo
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setVoucherNo($voucherNo = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNo) && !is_string($voucherNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNo, true), gettype($voucherNo)), __LINE__);
        }
        $this->VoucherNo = $voucherNo;
        return $this;
    }
    /**
     * Get SubCode value
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->SubCode;
    }
    /**
     * Set SubCode value
     * @param string $subCode
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setSubCode($subCode = null)
    {
        // validation for constraint: string
        if (!is_null($subCode) && !is_string($subCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCode, true), gettype($subCode)), __LINE__);
        }
        $this->SubCode = $subCode;
        return $this;
    }
    /**
     * Get BelongsTo value
     * @return string|null
     */
    public function getBelongsTo()
    {
        return $this->BelongsTo;
    }
    /**
     * Set BelongsTo value
     * @param string $belongsTo
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setBelongsTo($belongsTo = null)
    {
        // validation for constraint: string
        if (!is_null($belongsTo) && !is_string($belongsTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($belongsTo, true), gettype($belongsTo)), __LINE__);
        }
        $this->BelongsTo = $belongsTo;
        return $this;
    }
    /**
     * Get DeliverTo value
     * @return string|null
     */
    public function getDeliverTo()
    {
        return $this->DeliverTo;
    }
    /**
     * Set DeliverTo value
     * @param string $deliverTo
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setDeliverTo($deliverTo = null)
    {
        // validation for constraint: string
        if (!is_null($deliverTo) && !is_string($deliverTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverTo, true), gettype($deliverTo)), __LINE__);
        }
        $this->DeliverTo = $deliverTo;
        return $this;
    }
    /**
     * Get ContentsDescription value
     * @return string|null
     */
    public function getContentsDescription()
    {
        return $this->ContentsDescription;
    }
    /**
     * Set ContentsDescription value
     * @param string $contentsDescription
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setContentsDescription($contentsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($contentsDescription) && !is_string($contentsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentsDescription, true), gettype($contentsDescription)), __LINE__);
        }
        $this->ContentsDescription = $contentsDescription;
        return $this;
    }
    /**
     * Get SendAndReturnRecipient value
     * @return string|null
     */
    public function getSendAndReturnRecipient()
    {
        return $this->SendAndReturnRecipient;
    }
    /**
     * Set SendAndReturnRecipient value
     * @param string $sendAndReturnRecipient
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setSendAndReturnRecipient($sendAndReturnRecipient = null)
    {
        // validation for constraint: string
        if (!is_null($sendAndReturnRecipient) && !is_string($sendAndReturnRecipient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendAndReturnRecipient, true), gettype($sendAndReturnRecipient)), __LINE__);
        }
        $this->SendAndReturnRecipient = $sendAndReturnRecipient;
        return $this;
    }
    /**
     * Get ExtraInfo value
     * @return string|null
     */
    public function getExtraInfo()
    {
        return $this->ExtraInfo;
    }
    /**
     * Set ExtraInfo value
     * @param string $extraInfo
     * @return \Geniki\GenikiStruct\GenikiRecord
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        $this->ExtraInfo = $extraInfo;
        return $this;
    }
}
