<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReturnRequestOfVoucher GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetReturnRequestOfVoucher extends AbstractStructBase
{
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * The sVoucherNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sVoucherNumber;
    /**
     * Constructor method for GetReturnRequestOfVoucher
     * @uses GenikiGetReturnRequestOfVoucher::setSAuthKey()
     * @uses GenikiGetReturnRequestOfVoucher::setSVoucherNumber()
     * @param string $sAuthKey
     * @param string $sVoucherNumber
     */
    public function __construct($sAuthKey = null, $sVoucherNumber = null)
    {
        $this
            ->setSAuthKey($sAuthKey)
            ->setSVoucherNumber($sVoucherNumber);
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestOfVoucher
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
    /**
     * Get sVoucherNumber value
     * @return string|null
     */
    public function getSVoucherNumber()
    {
        return $this->sVoucherNumber;
    }
    /**
     * Set sVoucherNumber value
     * @param string $sVoucherNumber
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestOfVoucher
     */
    public function setSVoucherNumber($sVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sVoucherNumber) && !is_string($sVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sVoucherNumber, true), gettype($sVoucherNumber)), __LINE__);
        }
        $this->sVoucherNumber = $sVoucherNumber;
        return $this;
    }
}
