<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Close GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiClose extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ClosePendingJobs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiClosePendingJobs $parameters
     * @return \Geniki\GenikiStruct\GenikiClosePendingJobsResponse|bool
     */
    public function ClosePendingJobs(\Geniki\GenikiStruct\GenikiClosePendingJobs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ClosePendingJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ClosePendingJobsByDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiClosePendingJobsByDate $parameters
     * @return \Geniki\GenikiStruct\GenikiClosePendingJobsByDateResponse|bool
     */
    public function ClosePendingJobsByDate(\Geniki\GenikiStruct\GenikiClosePendingJobsByDate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ClosePendingJobsByDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiClosePendingJobsByDateResponse|\Geniki\GenikiStruct\GenikiClosePendingJobsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
