<?php

namespace Geniki\GenikiEnum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CountType GenikiEnum
 * @package Geniki
 * @subpackage Enumerations
 */
class GenikiCountType extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'JobsOnly'
     * @return string 'JobsOnly'
     */
    const VALUE_JOBS_ONLY = 'JobsOnly';
    /**
     * Constant for value 'All'
     * @return string 'All'
     */
    const VALUE_ALL = 'All';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_JOBS_ONLY
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_JOBS_ONLY,
            self::VALUE_ALL,
        );
    }
}
