<?php

namespace Geniki\GenikiArray;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRecord GenikiArray
 * @package Geniki
 * @subpackage Arrays
 */
class GenikiArrayOfRecord extends AbstractStructArrayBase
{
    /**
     * The Record
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Geniki\GenikiStruct\GenikiRecord[]
     */
    public $Record;
    /**
     * Constructor method for ArrayOfRecord
     * @uses GenikiArrayOfRecord::setRecord()
     * @param \Geniki\GenikiStruct\GenikiRecord[] $record
     */
    public function __construct(array $record = array())
    {
        $this
            ->setRecord($record);
    }
    /**
     * Get Record value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Geniki\GenikiStruct\GenikiRecord[]|null
     */
    public function getRecord()
    {
        return isset($this->Record) ? $this->Record : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecordForArrayConstraintsFromSetRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRecordRecordItem) {
            // validation for constraint: itemType
            if (!$arrayOfRecordRecordItem instanceof \Geniki\GenikiStruct\GenikiRecord) {
                $invalidValues[] = is_object($arrayOfRecordRecordItem) ? get_class($arrayOfRecordRecordItem) : sprintf('%s(%s)', gettype($arrayOfRecordRecordItem), var_export($arrayOfRecordRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Record property can only contain items of type \Geniki\GenikiStruct\GenikiRecord, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Record value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Geniki\GenikiStruct\GenikiRecord[] $record
     * @return \Geniki\GenikiArray\GenikiArrayOfRecord
     */
    public function setRecord(array $record = array())
    {
        // validation for constraint: array
        if ('' !== ($recordArrayErrorMessage = self::validateRecordForArrayConstraintsFromSetRecord($record))) {
            throw new \InvalidArgumentException($recordArrayErrorMessage, __LINE__);
        }
        if (is_null($record) || (is_array($record) && empty($record))) {
            unset($this->Record);
        } else {
            $this->Record = $record;
        }
        return $this;
    }
    /**
     * Add item to Record value
     * @throws \InvalidArgumentException
     * @param \Geniki\GenikiStruct\GenikiRecord $item
     * @return \Geniki\GenikiArray\GenikiArrayOfRecord
     */
    public function addToRecord(\Geniki\GenikiStruct\GenikiRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Geniki\GenikiStruct\GenikiRecord) {
            throw new \InvalidArgumentException(sprintf('The Record property can only contain items of type \Geniki\GenikiStruct\GenikiRecord, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Record[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Geniki\GenikiStruct\GenikiRecord|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Geniki\GenikiStruct\GenikiRecord|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Geniki\GenikiStruct\GenikiRecord|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Geniki\GenikiStruct\GenikiRecord|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Geniki\GenikiStruct\GenikiRecord|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Record
     */
    public function getAttributeName()
    {
        return 'Record';
    }
}
