<?php

namespace Geniki\GenikiArray;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLockerInfo GenikiArray
 * @package Geniki
 * @subpackage Arrays
 */
class GenikiArrayOfLockerInfo extends AbstractStructArrayBase
{
    /**
     * The LockerInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Geniki\GenikiStruct\GenikiLockerInfo[]
     */
    public $LockerInfo;
    /**
     * Constructor method for ArrayOfLockerInfo
     * @uses GenikiArrayOfLockerInfo::setLockerInfo()
     * @param \Geniki\GenikiStruct\GenikiLockerInfo[] $lockerInfo
     */
    public function __construct(array $lockerInfo = array())
    {
        $this
            ->setLockerInfo($lockerInfo);
    }
    /**
     * Get LockerInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Geniki\GenikiStruct\GenikiLockerInfo[]|null
     */
    public function getLockerInfo()
    {
        return isset($this->LockerInfo) ? $this->LockerInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLockerInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLockerInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLockerInfoForArrayConstraintsFromSetLockerInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLockerInfoLockerInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfLockerInfoLockerInfoItem instanceof \Geniki\GenikiStruct\GenikiLockerInfo) {
                $invalidValues[] = is_object($arrayOfLockerInfoLockerInfoItem) ? get_class($arrayOfLockerInfoLockerInfoItem) : sprintf('%s(%s)', gettype($arrayOfLockerInfoLockerInfoItem), var_export($arrayOfLockerInfoLockerInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LockerInfo property can only contain items of type \Geniki\GenikiStruct\GenikiLockerInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LockerInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Geniki\GenikiStruct\GenikiLockerInfo[] $lockerInfo
     * @return \Geniki\GenikiArray\GenikiArrayOfLockerInfo
     */
    public function setLockerInfo(array $lockerInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($lockerInfoArrayErrorMessage = self::validateLockerInfoForArrayConstraintsFromSetLockerInfo($lockerInfo))) {
            throw new \InvalidArgumentException($lockerInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($lockerInfo) || (is_array($lockerInfo) && empty($lockerInfo))) {
            unset($this->LockerInfo);
        } else {
            $this->LockerInfo = $lockerInfo;
        }
        return $this;
    }
    /**
     * Add item to LockerInfo value
     * @throws \InvalidArgumentException
     * @param \Geniki\GenikiStruct\GenikiLockerInfo $item
     * @return \Geniki\GenikiArray\GenikiArrayOfLockerInfo
     */
    public function addToLockerInfo(\Geniki\GenikiStruct\GenikiLockerInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Geniki\GenikiStruct\GenikiLockerInfo) {
            throw new \InvalidArgumentException(sprintf('The LockerInfo property can only contain items of type \Geniki\GenikiStruct\GenikiLockerInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LockerInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Geniki\GenikiStruct\GenikiLockerInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Geniki\GenikiStruct\GenikiLockerInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Geniki\GenikiStruct\GenikiLockerInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Geniki\GenikiStruct\GenikiLockerInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Geniki\GenikiStruct\GenikiLockerInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LockerInfo
     */
    public function getAttributeName()
    {
        return 'LockerInfo';
    }
}
