<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherJob GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetVoucherJob extends AbstractStructBase
{
    /**
     * The nJobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nJobId;
    /**
     * The sAuthKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sAuthKey;
    /**
     * Constructor method for GetVoucherJob
     * @uses GenikiGetVoucherJob::setNJobId()
     * @uses GenikiGetVoucherJob::setSAuthKey()
     * @param int $nJobId
     * @param string $sAuthKey
     */
    public function __construct($nJobId = null, $sAuthKey = null)
    {
        $this
            ->setNJobId($nJobId)
            ->setSAuthKey($sAuthKey);
    }
    /**
     * Get nJobId value
     * @return int
     */
    public function getNJobId()
    {
        return $this->nJobId;
    }
    /**
     * Set nJobId value
     * @param int $nJobId
     * @return \Geniki\GenikiStruct\GenikiGetVoucherJob
     */
    public function setNJobId($nJobId = null)
    {
        // validation for constraint: int
        if (!is_null($nJobId) && !(is_int($nJobId) || ctype_digit($nJobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nJobId, true), gettype($nJobId)), __LINE__);
        }
        $this->nJobId = $nJobId;
        return $this;
    }
    /**
     * Get sAuthKey value
     * @return string|null
     */
    public function getSAuthKey()
    {
        return $this->sAuthKey;
    }
    /**
     * Set sAuthKey value
     * @param string $sAuthKey
     * @return \Geniki\GenikiStruct\GenikiGetVoucherJob
     */
    public function setSAuthKey($sAuthKey = null)
    {
        // validation for constraint: string
        if (!is_null($sAuthKey) && !is_string($sAuthKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sAuthKey, true), gettype($sAuthKey)), __LINE__);
        }
        $this->sAuthKey = $sAuthKey;
        return $this;
    }
}
