<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCODReleaseResult GenikiStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateCODReleaseResult
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCreateCODReleaseResult extends GenikiMethodResult
{
    /**
     * The CodAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CodAmount;
    /**
     * The VoucherNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherNo;
    /**
     * Constructor method for CreateCODReleaseResult
     * @uses GenikiCreateCODReleaseResult::setCodAmount()
     * @uses GenikiCreateCODReleaseResult::setVoucherNo()
     * @param float $codAmount
     * @param string $voucherNo
     */
    public function __construct($codAmount = null, $voucherNo = null)
    {
        $this
            ->setCodAmount($codAmount)
            ->setVoucherNo($voucherNo);
    }
    /**
     * Get CodAmount value
     * @return float
     */
    public function getCodAmount()
    {
        return $this->CodAmount;
    }
    /**
     * Set CodAmount value
     * @param float $codAmount
     * @return \Geniki\GenikiStruct\GenikiCreateCODReleaseResult
     */
    public function setCodAmount($codAmount = null)
    {
        // validation for constraint: float
        if (!is_null($codAmount) && !(is_float($codAmount) || is_numeric($codAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codAmount, true), gettype($codAmount)), __LINE__);
        }
        $this->CodAmount = $codAmount;
        return $this;
    }
    /**
     * Get VoucherNo value
     * @return string|null
     */
    public function getVoucherNo()
    {
        return $this->VoucherNo;
    }
    /**
     * Set VoucherNo value
     * @param string $voucherNo
     * @return \Geniki\GenikiStruct\GenikiCreateCODReleaseResult
     */
    public function setVoucherNo($voucherNo = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNo) && !is_string($voucherNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNo, true), gettype($voucherNo)), __LINE__);
        }
        $this->VoucherNo = $voucherNo;
        return $this;
    }
}
