<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateCostResult GenikiStruct
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CalculateCostResult
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCalculateCostResult extends GenikiMethodResult
{
    /**
     * The Cost
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Cost;
    /**
     * The Vat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Vat;
    /**
     * Constructor method for CalculateCostResult
     * @uses GenikiCalculateCostResult::setCost()
     * @uses GenikiCalculateCostResult::setVat()
     * @param float $cost
     * @param float $vat
     */
    public function __construct($cost = null, $vat = null)
    {
        $this
            ->setCost($cost)
            ->setVat($vat);
    }
    /**
     * Get Cost value
     * @return float
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param float $cost
     * @return \Geniki\GenikiStruct\GenikiCalculateCostResult
     */
    public function setCost($cost = null)
    {
        // validation for constraint: float
        if (!is_null($cost) && !(is_float($cost) || is_numeric($cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cost, true), gettype($cost)), __LINE__);
        }
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get Vat value
     * @return float
     */
    public function getVat()
    {
        return $this->Vat;
    }
    /**
     * Set Vat value
     * @param float $vat
     * @return \Geniki\GenikiStruct\GenikiCalculateCostResult
     */
    public function setVat($vat = null)
    {
        // validation for constraint: float
        if (!is_null($vat) && !(is_float($vat) || is_numeric($vat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat, true), gettype($vat)), __LINE__);
        }
        $this->Vat = $vat;
        return $this;
    }
}
