<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupingRecord GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGroupingRecord extends AbstractStructBase
{
    /**
     * The JobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $JobId;
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Voucher;
    /**
     * The GroupingVoucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupingVoucher;
    /**
     * The GroupingShop
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GroupingShop;
    /**
     * Constructor method for GroupingRecord
     * @uses GenikiGroupingRecord::setJobId()
     * @uses GenikiGroupingRecord::setVoucher()
     * @uses GenikiGroupingRecord::setGroupingVoucher()
     * @uses GenikiGroupingRecord::setGroupingShop()
     * @param int $jobId
     * @param string $voucher
     * @param string $groupingVoucher
     * @param string $groupingShop
     */
    public function __construct($jobId = null, $voucher = null, $groupingVoucher = null, $groupingShop = null)
    {
        $this
            ->setJobId($jobId)
            ->setVoucher($voucher)
            ->setGroupingVoucher($groupingVoucher)
            ->setGroupingShop($groupingShop);
    }
    /**
     * Get JobId value
     * @return int
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param int $jobId
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
    /**
     * Get Voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param string $voucher
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord
     */
    public function setVoucher($voucher = null)
    {
        // validation for constraint: string
        if (!is_null($voucher) && !is_string($voucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher, true), gettype($voucher)), __LINE__);
        }
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get GroupingVoucher value
     * @return string|null
     */
    public function getGroupingVoucher()
    {
        return $this->GroupingVoucher;
    }
    /**
     * Set GroupingVoucher value
     * @param string $groupingVoucher
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord
     */
    public function setGroupingVoucher($groupingVoucher = null)
    {
        // validation for constraint: string
        if (!is_null($groupingVoucher) && !is_string($groupingVoucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupingVoucher, true), gettype($groupingVoucher)), __LINE__);
        }
        $this->GroupingVoucher = $groupingVoucher;
        return $this;
    }
    /**
     * Get GroupingShop value
     * @return string|null
     */
    public function getGroupingShop()
    {
        return $this->GroupingShop;
    }
    /**
     * Set GroupingShop value
     * @param string $groupingShop
     * @return \Geniki\GenikiStruct\GenikiGroupingRecord
     */
    public function setGroupingShop($groupingShop = null)
    {
        // validation for constraint: string
        if (!is_null($groupingShop) && !is_string($groupingShop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupingShop, true), gettype($groupingShop)), __LINE__);
        }
        $this->GroupingShop = $groupingShop;
        return $this;
    }
}
