<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPickupJobStatus GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetPickupJobStatus extends AbstractStructBase
{
    /**
     * The jobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $jobId;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * Constructor method for GetPickupJobStatus
     * @uses GenikiGetPickupJobStatus::setJobId()
     * @uses GenikiGetPickupJobStatus::setAuthKey()
     * @param int $jobId
     * @param string $authKey
     */
    public function __construct($jobId = null, $authKey = null)
    {
        $this
            ->setJobId($jobId)
            ->setAuthKey($authKey);
    }
    /**
     * Get jobId value
     * @return int
     */
    public function getJobId()
    {
        return $this->jobId;
    }
    /**
     * Set jobId value
     * @param int $jobId
     * @return \Geniki\GenikiStruct\GenikiGetPickupJobStatus
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->jobId = $jobId;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiGetPickupJobStatus
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
}
