<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Echo GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiEcho extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Echo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiEcho $parameters
     * @return \Geniki\GenikiStruct\GenikiEchoResponse|bool
     */
    public function _Echo(\Geniki\GenikiStruct\GenikiEcho $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Echo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiEchoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
