<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authenticate GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiAuthenticate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Authenticate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiAuthenticate $parameters
     * @return \Geniki\GenikiStruct\GenikiAuthenticateResponse|bool
     */
    public function Authenticate(\Geniki\GenikiStruct\GenikiAuthenticate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Authenticate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiAuthenticateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
