<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherZPL GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetVoucherZPL extends AbstractStructBase
{
    /**
     * The format
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $format;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The voucherNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucherNo;
    /**
     * Constructor method for GetVoucherZPL
     * @uses GenikiGetVoucherZPL::setFormat()
     * @uses GenikiGetVoucherZPL::setAuthKey()
     * @uses GenikiGetVoucherZPL::setVoucherNo()
     * @param string $format
     * @param string $authKey
     * @param string $voucherNo
     */
    public function __construct($format = null, $authKey = null, $voucherNo = null)
    {
        $this
            ->setFormat($format)
            ->setAuthKey($authKey)
            ->setVoucherNo($voucherNo);
    }
    /**
     * Get format value
     * @return string
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Geniki\GenikiEnum\GenikiMediaFormatZPL::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiMediaFormatZPL::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Geniki\GenikiStruct\GenikiGetVoucherZPL
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiMediaFormatZPL::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiMediaFormatZPL', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \Geniki\GenikiEnum\GenikiMediaFormatZPL::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiGetVoucherZPL
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get voucherNo value
     * @return string|null
     */
    public function getVoucherNo()
    {
        return $this->voucherNo;
    }
    /**
     * Set voucherNo value
     * @param string $voucherNo
     * @return \Geniki\GenikiStruct\GenikiGetVoucherZPL
     */
    public function setVoucherNo($voucherNo = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNo) && !is_string($voucherNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNo, true), gettype($voucherNo)), __LINE__);
        }
        $this->voucherNo = $voucherNo;
        return $this;
    }
}
