<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVoucherReturnOrder GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetVoucherReturnOrder extends AbstractStructBase
{
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The voucherNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucherNumber;
    /**
     * Constructor method for GetVoucherReturnOrder
     * @uses GenikiGetVoucherReturnOrder::setAuthKey()
     * @uses GenikiGetVoucherReturnOrder::setVoucherNumber()
     * @param string $authKey
     * @param string $voucherNumber
     */
    public function __construct($authKey = null, $voucherNumber = null)
    {
        $this
            ->setAuthKey($authKey)
            ->setVoucherNumber($voucherNumber);
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiGetVoucherReturnOrder
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get voucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->voucherNumber;
    }
    /**
     * Set voucherNumber value
     * @param string $voucherNumber
     * @return \Geniki\GenikiStruct\GenikiGetVoucherReturnOrder
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->voucherNumber = $voucherNumber;
        return $this;
    }
}
