<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateCODRelease GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCreateCODRelease extends AbstractStructBase
{
    /**
     * The codAmount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $codAmount;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The voucherNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucherNo;
    /**
     * Constructor method for CreateCODRelease
     * @uses GenikiCreateCODRelease::setCodAmount()
     * @uses GenikiCreateCODRelease::setAuthKey()
     * @uses GenikiCreateCODRelease::setVoucherNo()
     * @param float $codAmount
     * @param string $authKey
     * @param string $voucherNo
     */
    public function __construct($codAmount = null, $authKey = null, $voucherNo = null)
    {
        $this
            ->setCodAmount($codAmount)
            ->setAuthKey($authKey)
            ->setVoucherNo($voucherNo);
    }
    /**
     * Get codAmount value
     * @return float
     */
    public function getCodAmount()
    {
        return $this->codAmount;
    }
    /**
     * Set codAmount value
     * @param float $codAmount
     * @return \Geniki\GenikiStruct\GenikiCreateCODRelease
     */
    public function setCodAmount($codAmount = null)
    {
        // validation for constraint: float
        if (!is_null($codAmount) && !(is_float($codAmount) || is_numeric($codAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($codAmount, true), gettype($codAmount)), __LINE__);
        }
        $this->codAmount = $codAmount;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiCreateCODRelease
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get voucherNo value
     * @return string|null
     */
    public function getVoucherNo()
    {
        return $this->voucherNo;
    }
    /**
     * Set voucherNo value
     * @param string $voucherNo
     * @return \Geniki\GenikiStruct\GenikiCreateCODRelease
     */
    public function setVoucherNo($voucherNo = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNo) && !is_string($voucherNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNo, true), gettype($voucherNo)), __LINE__);
        }
        $this->voucherNo = $voucherNo;
        return $this;
    }
}
