<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVoucherPickupOrder GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiUpdateVoucherPickupOrder extends AbstractStructBase
{
    /**
     * The pickupDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pickupDate;
    /**
     * The dayQuarter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $dayQuarter;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The voucherNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucherNumber;
    /**
     * Constructor method for UpdateVoucherPickupOrder
     * @uses GenikiUpdateVoucherPickupOrder::setPickupDate()
     * @uses GenikiUpdateVoucherPickupOrder::setDayQuarter()
     * @uses GenikiUpdateVoucherPickupOrder::setAuthKey()
     * @uses GenikiUpdateVoucherPickupOrder::setVoucherNumber()
     * @param string $pickupDate
     * @param string $dayQuarter
     * @param string $authKey
     * @param string $voucherNumber
     */
    public function __construct($pickupDate = null, $dayQuarter = null, $authKey = null, $voucherNumber = null)
    {
        $this
            ->setPickupDate($pickupDate)
            ->setDayQuarter($dayQuarter)
            ->setAuthKey($authKey)
            ->setVoucherNumber($voucherNumber);
    }
    /**
     * Get pickupDate value
     * @return string
     */
    public function getPickupDate()
    {
        return $this->pickupDate;
    }
    /**
     * Set pickupDate value
     * @param string $pickupDate
     * @return \Geniki\GenikiStruct\GenikiUpdateVoucherPickupOrder
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        $this->pickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get dayQuarter value
     * @return string
     */
    public function getDayQuarter()
    {
        return $this->dayQuarter;
    }
    /**
     * Set dayQuarter value
     * @uses \Geniki\GenikiEnum\GenikiDayQuarter::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiDayQuarter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dayQuarter
     * @return \Geniki\GenikiStruct\GenikiUpdateVoucherPickupOrder
     */
    public function setDayQuarter($dayQuarter = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiDayQuarter::valueIsValid($dayQuarter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiDayQuarter', is_array($dayQuarter) ? implode(', ', $dayQuarter) : var_export($dayQuarter, true), implode(', ', \Geniki\GenikiEnum\GenikiDayQuarter::getValidValues())), __LINE__);
        }
        $this->dayQuarter = $dayQuarter;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiUpdateVoucherPickupOrder
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get voucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->voucherNumber;
    }
    /**
     * Set voucherNumber value
     * @param string $voucherNumber
     * @return \Geniki\GenikiStruct\GenikiUpdateVoucherPickupOrder
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->voucherNumber = $voucherNumber;
        return $this;
    }
}
