<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Track GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiTrack extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TrackDeliveryStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiTrackDeliveryStatus $parameters
     * @return \Geniki\GenikiStruct\GenikiTrackDeliveryStatusResponse|bool
     */
    public function TrackDeliveryStatus(\Geniki\GenikiStruct\GenikiTrackDeliveryStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TrackDeliveryStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TrackAndTrace
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiTrackAndTrace $parameters
     * @return \Geniki\GenikiStruct\GenikiTrackAndTraceResponse|bool
     */
    public function TrackAndTrace(\Geniki\GenikiStruct\GenikiTrackAndTrace $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TrackAndTrace($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiTrackAndTraceResponse|\Geniki\GenikiStruct\GenikiTrackDeliveryStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
