<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffiliateTrackingPair GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiAffiliateTrackingPair extends AbstractStructBase
{
    /**
     * The InsertedAt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InsertedAt;
    /**
     * The TrackingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingId;
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Voucher;
    /**
     * Constructor method for AffiliateTrackingPair
     * @uses GenikiAffiliateTrackingPair::setInsertedAt()
     * @uses GenikiAffiliateTrackingPair::setTrackingId()
     * @uses GenikiAffiliateTrackingPair::setVoucher()
     * @param string $insertedAt
     * @param string $trackingId
     * @param string $voucher
     */
    public function __construct($insertedAt = null, $trackingId = null, $voucher = null)
    {
        $this
            ->setInsertedAt($insertedAt)
            ->setTrackingId($trackingId)
            ->setVoucher($voucher);
    }
    /**
     * Get InsertedAt value
     * @return string
     */
    public function getInsertedAt()
    {
        return $this->InsertedAt;
    }
    /**
     * Set InsertedAt value
     * @param string $insertedAt
     * @return \Geniki\GenikiStruct\GenikiAffiliateTrackingPair
     */
    public function setInsertedAt($insertedAt = null)
    {
        // validation for constraint: string
        if (!is_null($insertedAt) && !is_string($insertedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($insertedAt, true), gettype($insertedAt)), __LINE__);
        }
        $this->InsertedAt = $insertedAt;
        return $this;
    }
    /**
     * Get TrackingId value
     * @return string|null
     */
    public function getTrackingId()
    {
        return $this->TrackingId;
    }
    /**
     * Set TrackingId value
     * @param string $trackingId
     * @return \Geniki\GenikiStruct\GenikiAffiliateTrackingPair
     */
    public function setTrackingId($trackingId = null)
    {
        // validation for constraint: string
        if (!is_null($trackingId) && !is_string($trackingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingId, true), gettype($trackingId)), __LINE__);
        }
        $this->TrackingId = $trackingId;
        return $this;
    }
    /**
     * Get Voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param string $voucher
     * @return \Geniki\GenikiStruct\GenikiAffiliateTrackingPair
     */
    public function setVoucher($voucher = null)
    {
        // validation for constraint: string
        if (!is_null($voucher) && !is_string($voucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher, true), gettype($voucher)), __LINE__);
        }
        $this->Voucher = $voucher;
        return $this;
    }
}
