<?php

namespace Geniki\GenikiService;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Calculate GenikiService
 * @package Geniki
 * @subpackage Services
 */
class GenikiCalculate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CalculateCost
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCalculateCost $parameters
     * @return \Geniki\GenikiStruct\GenikiCalculateCostResponse|bool
     */
    public function CalculateCost(\Geniki\GenikiStruct\GenikiCalculateCost $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateCost($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CalculateDay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Geniki\GenikiStruct\GenikiCalculateDay $parameters
     * @return \Geniki\GenikiStruct\GenikiCalculateDayResponse|bool
     */
    public function CalculateDay(\Geniki\GenikiStruct\GenikiCalculateDay $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CalculateDay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Geniki\GenikiStruct\GenikiCalculateCostResponse|\Geniki\GenikiStruct\GenikiCalculateDayResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
