<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateDay GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCalculateDay extends AbstractStructBase
{
    /**
     * The regionFromId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regionFromId;
    /**
     * The regionToId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $regionToId;
    /**
     * The receivedOn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $receivedOn;
    /**
     * The shipmentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $shipmentType;
    /**
     * The deliverOnSaturday
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $deliverOnSaturday;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * Constructor method for CalculateDay
     * @uses GenikiCalculateDay::setRegionFromId()
     * @uses GenikiCalculateDay::setRegionToId()
     * @uses GenikiCalculateDay::setReceivedOn()
     * @uses GenikiCalculateDay::setShipmentType()
     * @uses GenikiCalculateDay::setDeliverOnSaturday()
     * @uses GenikiCalculateDay::setAuthKey()
     * @param int $regionFromId
     * @param int $regionToId
     * @param string $receivedOn
     * @param string $shipmentType
     * @param bool $deliverOnSaturday
     * @param string $authKey
     */
    public function __construct($regionFromId = null, $regionToId = null, $receivedOn = null, $shipmentType = null, $deliverOnSaturday = null, $authKey = null)
    {
        $this
            ->setRegionFromId($regionFromId)
            ->setRegionToId($regionToId)
            ->setReceivedOn($receivedOn)
            ->setShipmentType($shipmentType)
            ->setDeliverOnSaturday($deliverOnSaturday)
            ->setAuthKey($authKey);
    }
    /**
     * Get regionFromId value
     * @return int
     */
    public function getRegionFromId()
    {
        return $this->regionFromId;
    }
    /**
     * Set regionFromId value
     * @param int $regionFromId
     * @return \Geniki\GenikiStruct\GenikiCalculateDay
     */
    public function setRegionFromId($regionFromId = null)
    {
        // validation for constraint: int
        if (!is_null($regionFromId) && !(is_int($regionFromId) || ctype_digit($regionFromId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regionFromId, true), gettype($regionFromId)), __LINE__);
        }
        $this->regionFromId = $regionFromId;
        return $this;
    }
    /**
     * Get regionToId value
     * @return int
     */
    public function getRegionToId()
    {
        return $this->regionToId;
    }
    /**
     * Set regionToId value
     * @param int $regionToId
     * @return \Geniki\GenikiStruct\GenikiCalculateDay
     */
    public function setRegionToId($regionToId = null)
    {
        // validation for constraint: int
        if (!is_null($regionToId) && !(is_int($regionToId) || ctype_digit($regionToId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regionToId, true), gettype($regionToId)), __LINE__);
        }
        $this->regionToId = $regionToId;
        return $this;
    }
    /**
     * Get receivedOn value
     * @return string
     */
    public function getReceivedOn()
    {
        return $this->receivedOn;
    }
    /**
     * Set receivedOn value
     * @param string $receivedOn
     * @return \Geniki\GenikiStruct\GenikiCalculateDay
     */
    public function setReceivedOn($receivedOn = null)
    {
        // validation for constraint: string
        if (!is_null($receivedOn) && !is_string($receivedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receivedOn, true), gettype($receivedOn)), __LINE__);
        }
        $this->receivedOn = $receivedOn;
        return $this;
    }
    /**
     * Get shipmentType value
     * @return string
     */
    public function getShipmentType()
    {
        return $this->shipmentType;
    }
    /**
     * Set shipmentType value
     * @uses \Geniki\GenikiEnum\GenikiShipmentType::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiShipmentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shipmentType
     * @return \Geniki\GenikiStruct\GenikiCalculateDay
     */
    public function setShipmentType($shipmentType = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiShipmentType::valueIsValid($shipmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiShipmentType', is_array($shipmentType) ? implode(', ', $shipmentType) : var_export($shipmentType, true), implode(', ', \Geniki\GenikiEnum\GenikiShipmentType::getValidValues())), __LINE__);
        }
        $this->shipmentType = $shipmentType;
        return $this;
    }
    /**
     * Get deliverOnSaturday value
     * @return bool
     */
    public function getDeliverOnSaturday()
    {
        return $this->deliverOnSaturday;
    }
    /**
     * Set deliverOnSaturday value
     * @param bool $deliverOnSaturday
     * @return \Geniki\GenikiStruct\GenikiCalculateDay
     */
    public function setDeliverOnSaturday($deliverOnSaturday = null)
    {
        // validation for constraint: boolean
        if (!is_null($deliverOnSaturday) && !is_bool($deliverOnSaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deliverOnSaturday, true), gettype($deliverOnSaturday)), __LINE__);
        }
        $this->deliverOnSaturday = $deliverOnSaturday;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiCalculateDay
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
}
