<?php

namespace Geniki\GenikiArray;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCheckpoint GenikiArray
 * @package Geniki
 * @subpackage Arrays
 */
class GenikiArrayOfCheckpoint extends AbstractStructArrayBase
{
    /**
     * The Checkpoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Geniki\GenikiStruct\GenikiCheckpoint[]
     */
    public $Checkpoint;
    /**
     * Constructor method for ArrayOfCheckpoint
     * @uses GenikiArrayOfCheckpoint::setCheckpoint()
     * @param \Geniki\GenikiStruct\GenikiCheckpoint[] $checkpoint
     */
    public function __construct(array $checkpoint = array())
    {
        $this
            ->setCheckpoint($checkpoint);
    }
    /**
     * Get Checkpoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Geniki\GenikiStruct\GenikiCheckpoint[]|null
     */
    public function getCheckpoint()
    {
        return isset($this->Checkpoint) ? $this->Checkpoint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCheckpoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckpoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCheckpointForArrayConstraintsFromSetCheckpoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCheckpointCheckpointItem) {
            // validation for constraint: itemType
            if (!$arrayOfCheckpointCheckpointItem instanceof \Geniki\GenikiStruct\GenikiCheckpoint) {
                $invalidValues[] = is_object($arrayOfCheckpointCheckpointItem) ? get_class($arrayOfCheckpointCheckpointItem) : sprintf('%s(%s)', gettype($arrayOfCheckpointCheckpointItem), var_export($arrayOfCheckpointCheckpointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Checkpoint property can only contain items of type \Geniki\GenikiStruct\GenikiCheckpoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Checkpoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Geniki\GenikiStruct\GenikiCheckpoint[] $checkpoint
     * @return \Geniki\GenikiArray\GenikiArrayOfCheckpoint
     */
    public function setCheckpoint(array $checkpoint = array())
    {
        // validation for constraint: array
        if ('' !== ($checkpointArrayErrorMessage = self::validateCheckpointForArrayConstraintsFromSetCheckpoint($checkpoint))) {
            throw new \InvalidArgumentException($checkpointArrayErrorMessage, __LINE__);
        }
        if (is_null($checkpoint) || (is_array($checkpoint) && empty($checkpoint))) {
            unset($this->Checkpoint);
        } else {
            $this->Checkpoint = $checkpoint;
        }
        return $this;
    }
    /**
     * Add item to Checkpoint value
     * @throws \InvalidArgumentException
     * @param \Geniki\GenikiStruct\GenikiCheckpoint $item
     * @return \Geniki\GenikiArray\GenikiArrayOfCheckpoint
     */
    public function addToCheckpoint(\Geniki\GenikiStruct\GenikiCheckpoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Geniki\GenikiStruct\GenikiCheckpoint) {
            throw new \InvalidArgumentException(sprintf('The Checkpoint property can only contain items of type \Geniki\GenikiStruct\GenikiCheckpoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Checkpoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Geniki\GenikiStruct\GenikiCheckpoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Geniki\GenikiStruct\GenikiCheckpoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Geniki\GenikiStruct\GenikiCheckpoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Geniki\GenikiStruct\GenikiCheckpoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Geniki\GenikiStruct\GenikiCheckpoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Checkpoint
     */
    public function getAttributeName()
    {
        return 'Checkpoint';
    }
}
