<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateVoucherReturnOrder GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCreateVoucherReturnOrder extends AbstractStructBase
{
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The voucherNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucherNumber;
    /**
     * The reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * Constructor method for CreateVoucherReturnOrder
     * @uses GenikiCreateVoucherReturnOrder::setAuthKey()
     * @uses GenikiCreateVoucherReturnOrder::setVoucherNumber()
     * @uses GenikiCreateVoucherReturnOrder::setReason()
     * @param string $authKey
     * @param string $voucherNumber
     * @param string $reason
     */
    public function __construct($authKey = null, $voucherNumber = null, $reason = null)
    {
        $this
            ->setAuthKey($authKey)
            ->setVoucherNumber($voucherNumber)
            ->setReason($reason);
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiCreateVoucherReturnOrder
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get voucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->voucherNumber;
    }
    /**
     * Set voucherNumber value
     * @param string $voucherNumber
     * @return \Geniki\GenikiStruct\GenikiCreateVoucherReturnOrder
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->voucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \Geniki\GenikiStruct\GenikiCreateVoucherReturnOrder
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
}
