<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobMethodResult GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiJobMethodResult extends GenikiMethodResult
{
    /**
     * The JobId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $JobId;
    /**
     * Constructor method for JobMethodResult
     * @uses GenikiJobMethodResult::setJobId()
     * @param int $jobId
     */
    public function __construct($jobId = null)
    {
        $this
            ->setJobId($jobId);
    }
    /**
     * Get JobId value
     * @return int
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param int $jobId
     * @return \Geniki\GenikiStruct\GenikiJobMethodResult
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !(is_int($jobId) || ctype_digit($jobId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
}
