<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReturnRequestsPdf GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiGetReturnRequestsPdf extends AbstractStructBase
{
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The returnSerials
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiArray\GenikiArrayOfString
     */
    public $returnSerials;
    /**
     * Constructor method for GetReturnRequestsPdf
     * @uses GenikiGetReturnRequestsPdf::setAuthKey()
     * @uses GenikiGetReturnRequestsPdf::setReturnSerials()
     * @param string $authKey
     * @param \Geniki\GenikiArray\GenikiArrayOfString $returnSerials
     */
    public function __construct($authKey = null, \Geniki\GenikiArray\GenikiArrayOfString $returnSerials = null)
    {
        $this
            ->setAuthKey($authKey)
            ->setReturnSerials($returnSerials);
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestsPdf
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get returnSerials value
     * @return \Geniki\GenikiArray\GenikiArrayOfString|null
     */
    public function getReturnSerials()
    {
        return $this->returnSerials;
    }
    /**
     * Set returnSerials value
     * @param \Geniki\GenikiArray\GenikiArrayOfString $returnSerials
     * @return \Geniki\GenikiStruct\GenikiGetReturnRequestsPdf
     */
    public function setReturnSerials(\Geniki\GenikiArray\GenikiArrayOfString $returnSerials = null)
    {
        $this->returnSerials = $returnSerials;
        return $this;
    }
}
