<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateJobResult GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCreateJobResult extends GenikiJobMethodResult
{
    /**
     * The Voucher
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Voucher;
    /**
     * The SubVouchers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiArray\GenikiArrayOfRecord
     */
    public $SubVouchers;
    /**
     * Constructor method for CreateJobResult
     * @uses GenikiCreateJobResult::setVoucher()
     * @uses GenikiCreateJobResult::setSubVouchers()
     * @param string $voucher
     * @param \Geniki\GenikiArray\GenikiArrayOfRecord $subVouchers
     */
    public function __construct($voucher = null, \Geniki\GenikiArray\GenikiArrayOfRecord $subVouchers = null)
    {
        $this
            ->setVoucher($voucher)
            ->setSubVouchers($subVouchers);
    }
    /**
     * Get Voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param string $voucher
     * @return \Geniki\GenikiStruct\GenikiCreateJobResult
     */
    public function setVoucher($voucher = null)
    {
        // validation for constraint: string
        if (!is_null($voucher) && !is_string($voucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher, true), gettype($voucher)), __LINE__);
        }
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get SubVouchers value
     * @return \Geniki\GenikiArray\GenikiArrayOfRecord|null
     */
    public function getSubVouchers()
    {
        return $this->SubVouchers;
    }
    /**
     * Set SubVouchers value
     * @param \Geniki\GenikiArray\GenikiArrayOfRecord $subVouchers
     * @return \Geniki\GenikiStruct\GenikiCreateJobResult
     */
    public function setSubVouchers(\Geniki\GenikiArray\GenikiArrayOfRecord $subVouchers = null)
    {
        $this->SubVouchers = $subVouchers;
        return $this;
    }
}
