<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseJob GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiBaseJob extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Id;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Date;
    /**
     * The IsClosed
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsClosed;
    /**
     * The IsCanceled
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCanceled;
    /**
     * The StatusDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StatusDate;
    /**
     * The ClosingBatch
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ClosingBatch;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $User;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * Constructor method for BaseJob
     * @uses GenikiBaseJob::setId()
     * @uses GenikiBaseJob::setType()
     * @uses GenikiBaseJob::setDate()
     * @uses GenikiBaseJob::setIsClosed()
     * @uses GenikiBaseJob::setIsCanceled()
     * @uses GenikiBaseJob::setStatusDate()
     * @uses GenikiBaseJob::setClosingBatch()
     * @uses GenikiBaseJob::setOrderId()
     * @uses GenikiBaseJob::setUser()
     * @uses GenikiBaseJob::setStatus()
     * @param int $id
     * @param string $type
     * @param string $date
     * @param bool $isClosed
     * @param bool $isCanceled
     * @param string $statusDate
     * @param int $closingBatch
     * @param string $orderId
     * @param string $user
     * @param string $status
     */
    public function __construct($id = null, $type = null, $date = null, $isClosed = null, $isCanceled = null, $statusDate = null, $closingBatch = null, $orderId = null, $user = null, $status = null)
    {
        $this
            ->setId($id)
            ->setType($type)
            ->setDate($date)
            ->setIsClosed($isClosed)
            ->setIsCanceled($isCanceled)
            ->setStatusDate($statusDate)
            ->setClosingBatch($closingBatch)
            ->setOrderId($orderId)
            ->setUser($user)
            ->setStatus($status);
    }
    /**
     * Get Id value
     * @return int
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \Geniki\GenikiEnum\GenikiJobType::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiJobType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiJobType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiJobType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \Geniki\GenikiEnum\GenikiJobType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get IsClosed value
     * @return bool
     */
    public function getIsClosed()
    {
        return $this->IsClosed;
    }
    /**
     * Set IsClosed value
     * @param bool $isClosed
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setIsClosed($isClosed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isClosed) && !is_bool($isClosed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isClosed, true), gettype($isClosed)), __LINE__);
        }
        $this->IsClosed = $isClosed;
        return $this;
    }
    /**
     * Get IsCanceled value
     * @return bool
     */
    public function getIsCanceled()
    {
        return $this->IsCanceled;
    }
    /**
     * Set IsCanceled value
     * @param bool $isCanceled
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setIsCanceled($isCanceled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCanceled) && !is_bool($isCanceled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCanceled, true), gettype($isCanceled)), __LINE__);
        }
        $this->IsCanceled = $isCanceled;
        return $this;
    }
    /**
     * Get StatusDate value
     * @return string
     */
    public function getStatusDate()
    {
        return $this->StatusDate;
    }
    /**
     * Set StatusDate value
     * @param string $statusDate
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setStatusDate($statusDate = null)
    {
        // validation for constraint: string
        if (!is_null($statusDate) && !is_string($statusDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusDate, true), gettype($statusDate)), __LINE__);
        }
        $this->StatusDate = $statusDate;
        return $this;
    }
    /**
     * Get ClosingBatch value
     * @return int
     */
    public function getClosingBatch()
    {
        return $this->ClosingBatch;
    }
    /**
     * Set ClosingBatch value
     * @param int $closingBatch
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setClosingBatch($closingBatch = null)
    {
        // validation for constraint: int
        if (!is_null($closingBatch) && !(is_int($closingBatch) || ctype_digit($closingBatch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($closingBatch, true), gettype($closingBatch)), __LINE__);
        }
        $this->ClosingBatch = $closingBatch;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get User value
     * @return string|null
     */
    public function getUser()
    {
        return $this->User;
    }
    /**
     * Set User value
     * @param string $user
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->User = $user;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Geniki\GenikiStruct\GenikiBaseJob
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
