<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateAffiliateTrackingPair GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCreateAffiliateTrackingPair extends AbstractStructBase
{
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The voucherNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $voucherNumber;
    /**
     * The trackingId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $trackingId;
    /**
     * Constructor method for CreateAffiliateTrackingPair
     * @uses GenikiCreateAffiliateTrackingPair::setAuthKey()
     * @uses GenikiCreateAffiliateTrackingPair::setVoucherNumber()
     * @uses GenikiCreateAffiliateTrackingPair::setTrackingId()
     * @param string $authKey
     * @param string $voucherNumber
     * @param string $trackingId
     */
    public function __construct($authKey = null, $voucherNumber = null, $trackingId = null)
    {
        $this
            ->setAuthKey($authKey)
            ->setVoucherNumber($voucherNumber)
            ->setTrackingId($trackingId);
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiCreateAffiliateTrackingPair
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get voucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->voucherNumber;
    }
    /**
     * Set voucherNumber value
     * @param string $voucherNumber
     * @return \Geniki\GenikiStruct\GenikiCreateAffiliateTrackingPair
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->voucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get trackingId value
     * @return string|null
     */
    public function getTrackingId()
    {
        return $this->trackingId;
    }
    /**
     * Set trackingId value
     * @param string $trackingId
     * @return \Geniki\GenikiStruct\GenikiCreateAffiliateTrackingPair
     */
    public function setTrackingId($trackingId = null)
    {
        // validation for constraint: string
        if (!is_null($trackingId) && !is_string($trackingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingId, true), gettype($trackingId)), __LINE__);
        }
        $this->trackingId = $trackingId;
        return $this;
    }
}
