<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoucherReturnOrder GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiVoucherReturnOrder extends AbstractStructBase
{
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherNumber;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueID;
    /**
     * The Reason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason;
    /**
     * Constructor method for VoucherReturnOrder
     * @uses GenikiVoucherReturnOrder::setVoucherNumber()
     * @uses GenikiVoucherReturnOrder::setUniqueID()
     * @uses GenikiVoucherReturnOrder::setReason()
     * @param string $voucherNumber
     * @param string $uniqueID
     * @param string $reason
     */
    public function __construct($voucherNumber = null, $uniqueID = null, $reason = null)
    {
        $this
            ->setVoucherNumber($voucherNumber)
            ->setUniqueID($uniqueID)
            ->setReason($reason);
    }
    /**
     * Get VoucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param string $voucherNumber
     * @return \Geniki\GenikiStruct\GenikiVoucherReturnOrder
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return string|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param string $uniqueID
     * @return \Geniki\GenikiStruct\GenikiVoucherReturnOrder
     */
    public function setUniqueID($uniqueID = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueID) && !is_string($uniqueID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueID, true), gettype($uniqueID)), __LINE__);
        }
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get Reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->Reason;
    }
    /**
     * Set Reason value
     * @param string $reason
     * @return \Geniki\GenikiStruct\GenikiVoucherReturnOrder
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason, true), gettype($reason)), __LINE__);
        }
        $this->Reason = $reason;
        return $this;
    }
}
