<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryParameters GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiQueryParameters extends AbstractStructBase
{
    /**
     * The DateFrom
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateFrom;
    /**
     * The DateTo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateTo;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $State;
    /**
     * The CounType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CounType;
    /**
     * The SearchType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SearchType;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VoucherNumber;
    /**
     * The ConsigneeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsigneeName;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for QueryParameters
     * @uses GenikiQueryParameters::setDateFrom()
     * @uses GenikiQueryParameters::setDateTo()
     * @uses GenikiQueryParameters::setState()
     * @uses GenikiQueryParameters::setCounType()
     * @uses GenikiQueryParameters::setSearchType()
     * @uses GenikiQueryParameters::setVoucherNumber()
     * @uses GenikiQueryParameters::setConsigneeName()
     * @uses GenikiQueryParameters::setOrderId()
     * @uses GenikiQueryParameters::setUserName()
     * @param string $dateFrom
     * @param string $dateTo
     * @param string $state
     * @param string $counType
     * @param string $searchType
     * @param string $voucherNumber
     * @param string $consigneeName
     * @param string $orderId
     * @param string $userName
     */
    public function __construct($dateFrom = null, $dateTo = null, $state = null, $counType = null, $searchType = null, $voucherNumber = null, $consigneeName = null, $orderId = null, $userName = null)
    {
        $this
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo)
            ->setState($state)
            ->setCounType($counType)
            ->setSearchType($searchType)
            ->setVoucherNumber($voucherNumber)
            ->setConsigneeName($consigneeName)
            ->setOrderId($orderId)
            ->setUserName($userName);
    }
    /**
     * Get DateFrom value
     * @return string
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param string $dateFrom
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFrom, true), gettype($dateFrom)), __LINE__);
        }
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return string
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param string $dateTo
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTo, true), gettype($dateTo)), __LINE__);
        }
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Get State value
     * @return string
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \Geniki\GenikiEnum\GenikiVoucherState::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiVoucherState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiVoucherState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiVoucherState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \Geniki\GenikiEnum\GenikiVoucherState::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get CounType value
     * @return string
     */
    public function getCounType()
    {
        return $this->CounType;
    }
    /**
     * Set CounType value
     * @uses \Geniki\GenikiEnum\GenikiCountType::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiCountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $counType
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setCounType($counType = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiCountType::valueIsValid($counType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiCountType', is_array($counType) ? implode(', ', $counType) : var_export($counType, true), implode(', ', \Geniki\GenikiEnum\GenikiCountType::getValidValues())), __LINE__);
        }
        $this->CounType = $counType;
        return $this;
    }
    /**
     * Get SearchType value
     * @return string
     */
    public function getSearchType()
    {
        return $this->SearchType;
    }
    /**
     * Set SearchType value
     * @uses \Geniki\GenikiEnum\GenikiSearchType::valueIsValid()
     * @uses \Geniki\GenikiEnum\GenikiSearchType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\Geniki\GenikiEnum\GenikiSearchType::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Geniki\GenikiEnum\GenikiSearchType', is_array($searchType) ? implode(', ', $searchType) : var_export($searchType, true), implode(', ', \Geniki\GenikiEnum\GenikiSearchType::getValidValues())), __LINE__);
        }
        $this->SearchType = $searchType;
        return $this;
    }
    /**
     * Get VoucherNumber value
     * @return string|null
     */
    public function getVoucherNumber()
    {
        return $this->VoucherNumber;
    }
    /**
     * Set VoucherNumber value
     * @param string $voucherNumber
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($voucherNumber) && !is_string($voucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        $this->VoucherNumber = $voucherNumber;
        return $this;
    }
    /**
     * Get ConsigneeName value
     * @return string|null
     */
    public function getConsigneeName()
    {
        return $this->ConsigneeName;
    }
    /**
     * Set ConsigneeName value
     * @param string $consigneeName
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setConsigneeName($consigneeName = null)
    {
        // validation for constraint: string
        if (!is_null($consigneeName) && !is_string($consigneeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consigneeName, true), gettype($consigneeName)), __LINE__);
        }
        $this->ConsigneeName = $consigneeName;
        return $this;
    }
    /**
     * Get OrderId value
     * @return string|null
     */
    public function getOrderId()
    {
        return $this->OrderId;
    }
    /**
     * Set OrderId value
     * @param string $orderId
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        $this->OrderId = $orderId;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \Geniki\GenikiStruct\GenikiQueryParameters
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
}
