<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EchoResponse GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiEchoResponse extends AbstractStructBase
{
    /**
     * The EchoResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EchoResult;
    /**
     * Constructor method for EchoResponse
     * @uses GenikiEchoResponse::setEchoResult()
     * @param int $echoResult
     */
    public function __construct($echoResult = null)
    {
        $this
            ->setEchoResult($echoResult);
    }
    /**
     * Get EchoResult value
     * @return int
     */
    public function getEchoResult()
    {
        return $this->EchoResult;
    }
    /**
     * Set EchoResult value
     * @param int $echoResult
     * @return \Geniki\GenikiStruct\GenikiEchoResponse
     */
    public function setEchoResult($echoResult = null)
    {
        // validation for constraint: int
        if (!is_null($echoResult) && !(is_int($echoResult) || ctype_digit($echoResult))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($echoResult, true), gettype($echoResult)), __LINE__);
        }
        $this->EchoResult = $echoResult;
        return $this;
    }
}
