<?php

namespace Geniki\GenikiStruct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateCost GenikiStruct
 * @package Geniki
 * @subpackage Structs
 */
class GenikiCalculateCost extends AbstractStructBase
{
    /**
     * The routeId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $routeId;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight;
    /**
     * The authKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authKey;
    /**
     * The services
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Geniki\GenikiArray\GenikiArrayOfString
     */
    public $services;
    /**
     * Constructor method for CalculateCost
     * @uses GenikiCalculateCost::setRouteId()
     * @uses GenikiCalculateCost::setWeight()
     * @uses GenikiCalculateCost::setAuthKey()
     * @uses GenikiCalculateCost::setServices()
     * @param int $routeId
     * @param float $weight
     * @param string $authKey
     * @param \Geniki\GenikiArray\GenikiArrayOfString $services
     */
    public function __construct($routeId = null, $weight = null, $authKey = null, \Geniki\GenikiArray\GenikiArrayOfString $services = null)
    {
        $this
            ->setRouteId($routeId)
            ->setWeight($weight)
            ->setAuthKey($authKey)
            ->setServices($services);
    }
    /**
     * Get routeId value
     * @return int
     */
    public function getRouteId()
    {
        return $this->routeId;
    }
    /**
     * Set routeId value
     * @param int $routeId
     * @return \Geniki\GenikiStruct\GenikiCalculateCost
     */
    public function setRouteId($routeId = null)
    {
        // validation for constraint: int
        if (!is_null($routeId) && !(is_int($routeId) || ctype_digit($routeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routeId, true), gettype($routeId)), __LINE__);
        }
        $this->routeId = $routeId;
        return $this;
    }
    /**
     * Get weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \Geniki\GenikiStruct\GenikiCalculateCost
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get authKey value
     * @return string|null
     */
    public function getAuthKey()
    {
        return $this->authKey;
    }
    /**
     * Set authKey value
     * @param string $authKey
     * @return \Geniki\GenikiStruct\GenikiCalculateCost
     */
    public function setAuthKey($authKey = null)
    {
        // validation for constraint: string
        if (!is_null($authKey) && !is_string($authKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authKey, true), gettype($authKey)), __LINE__);
        }
        $this->authKey = $authKey;
        return $this;
    }
    /**
     * Get services value
     * @return \Geniki\GenikiArray\GenikiArrayOfString|null
     */
    public function getServices()
    {
        return $this->services;
    }
    /**
     * Set services value
     * @param \Geniki\GenikiArray\GenikiArrayOfString $services
     * @return \Geniki\GenikiStruct\GenikiCalculateCost
     */
    public function setServices(\Geniki\GenikiArray\GenikiArrayOfString $services = null)
    {
        $this->services = $services;
        return $this;
    }
}
